#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <string.h>
#include <sys/sem.h>
#include <errno.h>
#include <signal.h>
#include <unistd.h>
/* Povecaj.c se izvrsava dva puta nakon cega se smanji.c izvrsava jednom. Nije bitan redosled pokretanja.
*/

union semun {
    int val;               
    struct semid_ds *buf;  
    ushort *array;        
};

int semid;

void izbrisiSemafor(int sig)
{
	printf("Prekinut sam sa CTR+C, brisem semafor\n");
	semctl(semid, 0, IPC_RMID);
	semctl(semid, 1, IPC_RMID);
	
	printf("Zavrsavam ... \n");
	exit(0);

}


int main()
{
    key_t key;
    int shmid;
    int *data;
    int mode;
    char dalje;
    int ind;
	 
    struct sembuf opr_p,opr_v;
    union semun operacija_nad_sem;

    signal(SIGINT,izbrisiSemafor);

    key = ftok("povecaj.c",'A');
    printf("Kljuc %d\n", key);
    shmid = shmget(key, sizeof(int), 0666|IPC_CREAT);
	printf("ID memorije %d\n", shmid);
    semid = semget(key,2, 0666|IPC_CREAT|IPC_EXCL);
    printf("ID semafora %d\n", semid);
    
    if (semid != -1) // semafor nije bio kreiran, ja sam ga kreirao
  	{
		printf("semafor nije bio kreiran, ja sam ga kreirao \n");
		operacija_nad_sem.val = 2;
		semctl(semid,0,SETVAL,operacija_nad_sem); //postavljanje vrednosti na 0
		operacija_nad_sem.val = 0;
		semctl(semid,1,SETVAL,operacija_nad_sem); //postavljanje vrednosti na 0
    }
    
    else if (errno == EEXIST)
    {
		printf("Semafor je kreirao i inicijalizovao neko drugi, ja se samo povezujem \n");
		semid = semget(key,2, 0);
    }
    
    else 
	{
		printf("Neka druga greska! Izlazim .. \n");
		exit(0);
	}

    opr_p.sem_num = 0; // smanjuje semafor 0
    opr_p.sem_op = -1;
    opr_p.sem_flg = 0;

    opr_v.sem_num = 1; // povecava semafor 1
    opr_v.sem_op = 1;
    opr_v.sem_flg = 0;

	data = (int*) shmat(shmid,(void *)0,0);
    *data = 5;

    while(1)
    {
        ind  = semop(semid,&opr_p,1);
		if (ind == -1) break;
        *data = *data + 2;
        printf("%d\n",*data);
        ind = semop(semid,&opr_v,1);
		if (ind == -1) break;
        sleep(1);
    }
    
}
